local assets =
{
    Asset("ANIM", "anim/condense.zip"),
	Asset("ATLAS", "images/inventoryimages/condense_rocks.xml"),
	Asset("ATLAS", "images/inventoryimages/condense_flint.xml"),
	Asset("ATLAS", "images/inventoryimages/condense_twigs.xml"),
	Asset("ATLAS", "images/inventoryimages/condense_nitre.xml"),
	Asset("ATLAS", "images/inventoryimages/condense_goldnugget.xml"),
	Asset("ATLAS", "images/inventoryimages/condense_cutgrass.xml"),
}

local function buildgene(lei)

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("condense")
    inst.AnimState:SetBuild("condense")
    inst.AnimState:PlayAnimation("idle",true)

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddComponent("stackable")
    inst:AddComponent("inspectable")
--分界线
    inst:AddComponent("inventoryitem")
	inst:AddComponent("tradable")
    inst.components.inventoryitem.imagename = "condense_"..lei
    inst.components.inventoryitem.atlasname = "images/inventoryimages/condense_"..lei..".xml"
    inst:AddComponent("selfstacker")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM
	inst.Transform:SetScale(1.5, 1.5, 1.5)

    MakeHauntableLaunchAndSmash(inst)

    return inst
end
return Prefab("condense_"..lei, fn, assets)

end
return 
    buildgene("rocks"),
	buildgene("flint"),
	buildgene("cutgrass"),
	buildgene("nitre"),
	buildgene("goldnugget"),
    buildgene("twigs",true)